﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Drawing.Imaging;


namespace IPBL
{
    public static class Filters
    {
        #region scales
        static public Bitmap rgb2gray(ref Bitmap bmp, string grayType)
        {
            int width = bmp.Width, height = bmp.Height;
            Bitmap bmpnew = new Bitmap(width, height);
            int[, ,] imagematris = Matris.Load.Matris3DFromeBMP(bmp);

            switch (grayType)
            {
                case "min":
                    {
                        for (int i = 0; i < width; i++)
                        {
                            for (int j = 0; j < height; j++)
                            {
                                int min = Math.Min(Math.Min(imagematris[i, j, 0], imagematris[i, j, 1]), imagematris[i, j, 2]);
                                bmpnew.SetPixel(i, j, Color.FromArgb(min, min, min));
                            }
                        }
                        break;
                    }
                case "avg":
                    {
                        for (int i = 0; i < width; i++)
                        {
                            for (int j = 0; j < height; j++)
                            {
                                int min = (imagematris[i, j, 0] + imagematris[i, j, 1] + imagematris[i, j, 2]) / 3;
                                bmpnew.SetPixel(i, j, Color.FromArgb(min, min, min));
                            }
                        }
                        break;
                    }
                case "max":
                    {
                        for (int i = 0; i < width; i++)
                        {
                            for (int j = 0; j < height; j++)
                            {
                                int max = Math.Max(Math.Max(imagematris[i, j, 0], imagematris[i, j, 1]), imagematris[i, j, 2]);
                                bmpnew.SetPixel(i, j, Color.FromArgb(max, max, max));
                            }
                        }
                        break;
                    }
            }

            //bmpnew.Save(new 
            return bmpnew;
        }
        public static Bitmap Scale(ref Bitmap bmp, double r, double g, double b)
        {
            int Width = bmp.Width, Height = bmp.Height;
            int[, ,] image = Matris.Load.Matris3DFromeBMP_(ref bmp);

            Scale(ref image, Width, Height, r, g, b);
            Matris.Math.ApplyThreshold(ref image, Width, Height, 255, 0);

            return Matris.Load.BMPfromeMatris3D(ref image, Width, Height);
        }
        public static void Scale(ref int[, ,] matris, int width, int height, double r, double g, double b)
        {
            for (int i = 0; i < width; i++) for (int j = 0; j < height; j++)
                    matris[i, j, 0] = matris[i, j, 1] = matris[i, j, 2] =
                        Convert.ToInt32(matris[i, j, 0] * r + matris[i, j, 1] * g + matris[i, j, 2] * b);
        }
        public static Bitmap SingelScaling(ref Bitmap image, double rz, double rj, double gz, double gj, double bz, double bj)
        {
            int width = image.Width, height = image.Height;
            Bitmap newimage = new Bitmap(width, height);

            for (int i = 0; i < width; i++)
            {
                for (int j = 0; j < height; j++)
                {
                    Color c = image.GetPixel(i, j);

                    int r = Convert.ToInt32(c.R * rz + rj);
                    r = r < 0 ? 0 : r > 255 ? 255 : r;
                    int g = Convert.ToInt32(c.G * gz + gj);
                    g = g < 0 ? 0 : g > 255 ? 255 : g;
                    int b = Convert.ToInt32(c.B * bz + bj);
                    b = b < 0 ? 0 : b > 255 ? 255 : b;

                    newimage.SetPixel(i, j, Color.FromArgb(r, g, b));
                }
            }

            return newimage;
        }

        public static Bitmap Normalize_(ref Bitmap image, int mode)
        {
            int[, ,] immat = Matris.Load.Matris3DFromeBMP_(ref image);
            Matris.Histogram.Normalize_(ref immat, image.Width, image.Height, mode);
            return Matris.Load.BMPfromeMatris3D(ref immat, image.Width, image.Height);
        }
        #endregion

        #region binary
        public static Bitmap binary(ref Bitmap bmp)
        {
            int width = bmp.Width, height = bmp.Height;
            Bitmap bmpnew = new Bitmap(width, height);
            for (int i = 0; i < width; i++)
            {
                for (int j = 0; j < height; j++)
                {
                    Color c = bmp.GetPixel(i, j);
                    bmpnew.SetPixel(i, j, c.R > 0 ? Color.White : Color.Black);
                }
            }
            return bmpnew;
        }
        public static int BestThresholdValue = 0;
        /// <param name="type">l , h , t : threshold = T</param>
        public static Bitmap binary(ref Bitmap image, string type, int threshold)
        {
            int[, ,] immat = Matris.Load.Matris3DFromeBMP_(ref image);
            binary(ref immat, image.Width, image.Height, type, threshold);
            return Matris.Load.BMPfromeMatris3D(ref immat, image.Width, image.Height);
        }
        public static void binary(ref int[, ,] image, int width, int height, string type, int Threshold)
        {
            switch (type)
            {
                    //special values
                case "T":
                    Matris.Math.ApplyThreshold(ref image, width, height, Threshold, 0);
                    break;
                case "best":
                    BestThresholdValue = Matris.Histogram.BestThresholdValue(ref image, width, height);
                    for (int i = 0; i < width; i++) for (int j = 0; j < height; j++)
                            image[i, j, 0] = image[i, j, 1] = image[i, j, 2] =
                                image[i, j, 0] > BestThresholdValue ? 1 : 0;
                    return;
                case "worst":
                    BestThresholdValue = Matris.Histogram.WorstThresholdValue(ref image, width, height);
                    for (int i = 0; i < width; i++) for (int j = 0; j < height; j++)
                            image[i, j, 0] = image[i, j, 1] = image[i, j, 2] =
                                image[i, j, 0] > BestThresholdValue ? 1 : 0;
                    return;
                    //chert values
                case "l":
                    for (int i = 0; i < width; i++) for (int j = 0; j < height; j++)
                            image[i, j, 0] = image[i, j, 1] = image[i, j, 2] =
                                (image[i, j, 0] + image[i, j, 1] + image[i, j, 2]) / 3 > 0 ? 1 : 0;
                    return;
                case "al":
                    for (int i = 0; i < width; i++) for (int j = 0; j < height; j++)
                            image[i, j, 0] = image[i, j, 1] = image[i, j, 2] =
                                (image[i, j, 0] == 0 && image[i, j, 1] == 0 && image[i, j, 2] == 0) ? 1 : 0;
                    return;
                case "sl":
                    for (int i = 0; i < width; i++) for (int j = 0; j < height; j++)
                            image[i, j, 0] = image[i, j, 1] = image[i, j, 2] =
                                (image[i, j, 0] == 0 || image[i, j, 1] == 0 || image[i, j, 2] == 0) ? 1 : 0;
                    return;
                case "h":
                    for (int i = 0; i < width; i++) for (int j = 0; j < height; j++)
                            image[i, j, 0] = image[i, j, 1] = image[i, j, 2] =
                                (image[i, j, 0] + image[i, j, 1] + image[i, j, 2]) / 3 == 255 ? 1 : 0;
                    return;
                case "ah":
                    for (int i = 0; i < width; i++) for (int j = 0; j < height; j++)
                            image[i, j, 0] = image[i, j, 1] = image[i, j, 2] =
                                (image[i, j, 0] == 255 && image[i, j, 1] == 255 && image[i, j, 2] == 255) ? 1 : 0;
                    return;
                case "sh":
                    for (int i = 0; i < width; i++) for (int j = 0; j < height; j++)
                            image[i, j, 0] = image[i, j, 1] = image[i, j, 2] =
                                (image[i, j, 0] == 255 || image[i, j, 1] == 255 || image[i, j, 2] == 255) ? 1 : 0;
                    return;
                case "t":
                    for (int i = 0; i < width; i++) for (int j = 0; j < height; j++)
                            image[i, j, 0] = image[i, j, 1] = image[i, j, 2] =
                                (image[i, j, 0] + image[i, j, 1] + image[i, j, 2]) / 3 >= Threshold ? 1 : 0;
                    return;
                case "st":
                    for (int i = 0; i < width; i++) for (int j = 0; j < height; j++)
                            image[i, j, 0] = image[i, j, 1] = image[i, j, 2] =
                                (image[i, j, 0] >= Threshold || image[i, j, 1] >= Threshold || image[i, j, 2] >= Threshold) ? 1 : 0;
                    return;
                case "at":
                    for (int i = 0; i < width; i++) for (int j = 0; j < height; j++)
                            image[i, j, 0] = image[i, j, 1] = image[i, j, 2] =
                                (image[i, j, 0] >= Threshold && image[i, j, 1] >= Threshold && image[i, j, 2] >= Threshold) ? 1 : 0;
                    return;
            }
        }
        public static void binary(ref int[,] image, int width, int height, string type, int Threshold)
        {
            switch (type)
            {
                    //low
                case "l":
                    for (int i = 0; i < width; i++) for (int j = 0; j < height; j++)
                            image[i, j] = image[i, j] > 0 ? 1 : 0;
                    return;
                    //absolute low
                case "al":
                    for (int i = 0; i < width; i++) for (int j = 0; j < height; j++)
                            image[i, j] = image[i, j] == 0 ? 1 : 0;
                    return;
                    //high
                case "h":
                    for (int i = 0; i < width; i++) for (int j = 0; j < height; j++)
                            image[i, j] = image[i, j] == 255 ? 1 : 0;
                    return;
                    //Threshold
                case "t":
                    for (int i = 0; i < width; i++) for (int j = 0; j < height; j++)
                            image[i, j] = image[i, j] >= Threshold ? 1 : 0;
                    return;
                    //absolute Threshold
                case "at":
                    for (int i = 0; i < width; i++) for (int j = 0; j < height; j++)
                            image[i, j] = image[i, j] == Threshold ? 1 : 0;
                    return;
            }
        }
        #endregion

        #region mask
        /// <summary>
        /// یک رنگ را از تصویر بیرون میکشد
        /// </summary>
        /// <param name="filename">نام فایل تصویر ورودی</param>
        /// <param name="ColorName">رنگ قرمز،آبی،یا سبز</param>
        /// <param name="FilterType">فرمت پیکسل برای تغییر</param>
        /// <returns>نام فایل خروجی</returns>
        public static Bitmap Mask(ref Bitmap image, bool R, bool G, bool B)
        {
            Bitmap newimage = new Bitmap(image);
            int width = image.Width,height=image.Height;

            for (int i = 0; i < width; i++)
            {
                for (int j = 0; j < height; j++)
                {
                    Color c = image.GetPixel(i, j);
                    newimage.SetPixel(i, j, Color.FromArgb(
                        R == true ? c.R : 0, G == true ? c.G : 0, B == true ? c.B : 0));
                }
            }

            return newimage;
        }
        static public Bitmap MaskByColor(ref Bitmap bmp, int r, int g, int b, int ErroreThreshold, string filterType)
        {
            int width = bmp.Width, height = bmp.Height;
            int[, ,] image = Matris.Load.Matris3DFromeBMP_(ref bmp);

            Matris.Histogram.MaskByColor(ref image, ref image, width, height, r, g, b, ErroreThreshold, filterType);

            return Matris.Load.BMPfromeMatris3D(ref image, width, height);
        }
        public static string MaskByColorRange(string filename, int sx, int sy, int ex, int ey,int ErroreThreshold, string type)
        {
            Bitmap bmp = new Bitmap(filename);
            int width = bmp.Width, height = bmp.Height;
            int[, ,] image = Matris.Load.Matris3DFromeBMP_(ref bmp);
            int[, ,] imageCopy = Matris.Load.Matris3DFromeBMP_(ref bmp);
            bmp.Dispose();

            string newfilename = null;
            //collecting informations
            switch (type)
            {
                case "cmyk":
                    Scale(ref imageCopy, width, height, 0.500, 0.481, 0.019);
                    int[, ,] Cadr = Matris.Edit.Crop(ref imageCopy, width, height, sx, sy, ex, ey);
                    int[,] Colsinfs = Matris.Histogram.AvgColors(ref Cadr, ex - sx + 1, ey - sy + 1);
                    int eT = 0;
                    if (ErroreThreshold == -1)
                        eT = Convert.ToInt32(Math.Max(Colsinfs[0, 2] - Colsinfs[0, 0],
                            Math.Max(Colsinfs[1, 2] - Colsinfs[1, 0], Colsinfs[2, 2] - Colsinfs[2, 0])) / 2)
                            // + 100 may be better!!!!
                            + 100;
                    else
                        eT = ErroreThreshold;

                    //applying filter
                    Matris.Histogram.MaskByColor(ref image, ref imageCopy, width, height, Colsinfs[0, 1], Colsinfs[1, 1], Colsinfs[2, 1], eT, "replace");
                    Matris.Math.ApplyThreshold(ref image, width, height, 255, 0);

                    newfilename = filename.Replace(".bmp", "_MaskedByColor-" +
                        Colsinfs[0, 1].ToString() + "-" + Colsinfs[1, 1].ToString() + "-" + Colsinfs[2, 1].ToString() + "-" +
                        eT.ToString() + "-" + type + ".bmp");
                    break;
                case "":
                    Cadr = Matris.Edit.Crop(ref image, width, height, sx, sy, ex, ey);
                    Colsinfs = Matris.Histogram.AvgColors(ref Cadr, ex - sx + 1, ey - sy + 1);
                    eT = 0;
                    if (ErroreThreshold == -1)
                        eT = Convert.ToInt32(Math.Max(Colsinfs[0, 2] - Colsinfs[0, 0],
                            Math.Max(Colsinfs[1, 2] - Colsinfs[1, 0], Colsinfs[2, 2] - Colsinfs[2, 0])) / 2)
                            //+ 100 may be better
                            + 100;
                    else
                        eT = ErroreThreshold;

                    //applying filter
                    Matris.Histogram.MaskByColor(ref image, ref image, width, height, Colsinfs[0, 1], Colsinfs[1, 1], Colsinfs[2, 1], eT, "");
                    Matris.Math.ApplyThreshold(ref image, width, height, 255, 0);

                    newfilename = filename.Replace(".bmp", "_MaskedByColor-" +
                        Colsinfs[0, 1].ToString() + "-" + Colsinfs[1, 1].ToString() + "-" + Colsinfs[2, 1].ToString() + "-" +
                        eT.ToString() + ".bmp");
                    break;
            }

            Matris.Save.Matris3DToBMPFile(ref image, width, height, newfilename);
            return newfilename;
        }
        public static Bitmap MaskByColorRange(ref Bitmap bmp, int sx, int sy, int ex, int ey, int ErroreThreshold, string type)
        {
            int width = bmp.Width, height = bmp.Height;
            int[, ,] image = Matris.Load.Matris3DFromeBMP_(ref bmp);
            int[, ,] imageCopy = Matris.Load.Matris3DFromeBMP_(ref bmp);
            bmp.Dispose();

            //collecting informations
            switch (type)
            {
                case "cmyk":
                    Scale(ref imageCopy, width, height, 0.500, 0.481, 0.019);
                    int[, ,] Cadr = Matris.Edit.Crop(ref imageCopy, width, height, sx, sy, ex, ey);
                    int[,] Colsinfs = Matris.Histogram.AvgColors(ref Cadr, ex - sx + 1, ey - sy + 1);
                    int eT = 0;
                    if (ErroreThreshold == -1)
                        eT = Convert.ToInt32(Math.Max(Colsinfs[0, 2] - Colsinfs[0, 0],
                            Math.Max(Colsinfs[1, 2] - Colsinfs[1, 0], Colsinfs[2, 2] - Colsinfs[2, 0])) / 2)
                            // + 100 may be better!!!!
                            + 100;
                    else
                        eT = ErroreThreshold;

                    //applying filter
                    Matris.Histogram.MaskByColor(ref image, ref imageCopy, width, height, Colsinfs[0, 1], Colsinfs[1, 1], Colsinfs[2, 1], eT, "replace");
                    Matris.Math.ApplyThreshold(ref image, width, height, 255, 0);

                    break;
                case "gray":
                    Cadr = Matris.Edit.Crop(ref image, width, height, sx, sy, ex, ey);
                    Colsinfs = Matris.Histogram.AvgColors(ref Cadr, ex - sx + 1, ey - sy + 1);
                    eT = 0;
                    if (ErroreThreshold == -1)
                        eT = Convert.ToInt32(Math.Max(Colsinfs[0, 2] - Colsinfs[0, 0],
                            Math.Max(Colsinfs[1, 2] - Colsinfs[1, 0], Colsinfs[2, 2] - Colsinfs[2, 0])) / 2)
                            //+ 100 may be better
                            + 100;
                    else
                        eT = ErroreThreshold;

                    //applying filter
                    Matris.Histogram.MaskByColor(ref image, ref image, width, height, Colsinfs[0, 1], Colsinfs[1, 1], Colsinfs[2, 1], eT, "gray");
                    Matris.Math.ApplyThreshold(ref image, width, height, 255, 0);
                    break;
                case "bw":
                case "black":
                    Cadr = Matris.Edit.Crop(ref image, width, height, sx, sy, ex, ey);
                    Colsinfs = Matris.Histogram.AvgColors(ref Cadr, ex - sx + 1, ey - sy + 1);
                    eT = 0;
                    if (ErroreThreshold == -1)
                        eT = Convert.ToInt32(Math.Max(Colsinfs[0, 2] - Colsinfs[0, 0],
                            Math.Max(Colsinfs[1, 2] - Colsinfs[1, 0], Colsinfs[2, 2] - Colsinfs[2, 0])) / 2)
                            //+ 100 may be better
                            + 100;
                    else
                        eT = ErroreThreshold;

                    //applying filter
                    Matris.Histogram.MaskByColor(ref image, ref image, width, height, Colsinfs[0, 1], Colsinfs[1, 1], Colsinfs[2, 1], eT, "black");
                    Matris.Math.ApplyThreshold(ref image, width, height, 255, 0);
                    break;
            }

            return Matris.Load.BMPfromeMatris3D(ref image, width, height);
        }
        #endregion

        #region light
        static public Bitmap rais(Bitmap bmp, string arg, int raisvalue)
        {
            int width = bmp.Width, height = bmp.Height;
            Bitmap bmpnew = new Bitmap(width, height);

            if (raisvalue == 0) raisvalue = 127;


            switch (arg)
            {
                case "r":
                case "red":
                    for (int i = 0; i < width; i++)
                    {
                        for (int j = 0; j < height; j++)
                        {
                            Color c = bmp.GetPixel(i, j);
                            int r = c.R, g = c.G, b = c.B;
                            r += raisvalue;
                            r = r > 255 ? 255 : r < 0 ? 0 : r;
                            bmpnew.SetPixel(i, j, Color.FromArgb(r, g, b));
                        }
                    }
                    break;
                case "g":
                case "green":
                    for (int i = 0; i < width; i++)
                    {
                        for (int j = 0; j < height; j++)
                        {
                            Color c = bmp.GetPixel(i, j);
                            int r = c.R, g = c.G, b = c.B;
                            g += raisvalue;
                            g = g > 255 ? 255 : g < 0 ? 0 : g;
                            bmpnew.SetPixel(i, j, Color.FromArgb(r, g, b));
                        }
                    }
                    break;
                case "b":
                case "blue":
                    for (int i = 0; i < width; i++)
                    {
                        for (int j = 0; j < height; j++)
                        {
                            Color c = bmp.GetPixel(i, j);
                            int r = c.R, g = c.G, b = c.B;
                            b += raisvalue;
                            b = b > 255 ? 255 : b < 0 ? 0 : b;
                            bmpnew.SetPixel(i, j, Color.FromArgb(r, g, b));
                        }
                    }
                    break;
                case "all":
                case "a":
                    for (int i = 0; i < width; i++)
                    {
                        for (int j = 0; j < height; j++)
                        {
                            Color c = bmp.GetPixel(i, j);
                            int r = c.R, g = c.G, b = c.B;
                            r += raisvalue;
                            r = r > 255 ? 255 : r < 0 ? 0 : r;
                            g += raisvalue;
                            g = g > 255 ? 255 : g < 0 ? 0 : g;
                            b += raisvalue;
                            b = b > 255 ? 255 : b < 0 ? 0 : b;
                            bmpnew.SetPixel(i, j, Color.FromArgb(r, g, b));
                        }
                    }
                    break;
            }//switch

            return bmpnew;
        }//rais
        /// <summary>
        /// افزایش سفیدی و روشنی تصویر
        /// </summary>
        /// <param name="raisValue">مقدار افزایش هر پیکسل</param>
        /// <param name="upperThreshold">مقدار حد بالا</param>
        /// <returns></returns>
        public static Bitmap bright(Bitmap image, int raisValue, int upperThreshold, int DownerThreshold)
        {
            int w = image.Width, h = image.Height;
            int[, ,] imageMatris1 = Matris.Load.Matris3DFromeBMP(image);
            Matris.Math.add(ref imageMatris1, w, h, raisValue);
            Matris.Math.ApplyThreshold(ref imageMatris1, w, h, 255, 0);

            return Matris.Load.BMPfromeMatris3D(ref imageMatris1, w, h);
        }
        public static Bitmap bright(ref Bitmap image, int raisValue, int upperThreshold, int DownerThreshold)
        {
            int w = image.Width, h = image.Height;
            int[, ,] imageMatris1 = Matris.Load.Matris3DFromeBMP(image);
            Matris.Math.add(ref imageMatris1, w, h, raisValue);
            Matris.Math.ApplyThreshold(ref imageMatris1, w, h, 255, 0);

            return Matris.Load.BMPfromeMatris3D(ref imageMatris1, w, h);
        }
        public static Bitmap Sbright(Bitmap image, int raisValue, int upperThreshold, int DownerThreshold)
        {
            int w = image.Width, h = image.Height;
            int[, ,] imageMatris1 = Matris.Load.Matris3DFromeBMP(image);

            int[, ,] imageMatris2 = Matris.Load.Matris3DFromeBMP(image);
            Matris.Math.add(ref imageMatris2, w, h, raisValue);

            Matris.Math.ShowFlow(ref imageMatris1, ref imageMatris2, w, h, upperThreshold, DownerThreshold);

            return Matris.Load.BMPfromeMatris3D(ref imageMatris2, w, h);
        }//special bright
        public static Bitmap gamma_correction(ref Bitmap image, double value)
        {
            int width = image.Width, height = image.Height;
            //else, gamma
            int[, ,] imagematris = Matris.Load.Matris3DFromeBMP(image);

            //defualt = 2.2
            double gamma = Math.Max(0.1, Math.Min(5.0, value));
            byte[] table = new byte[256];
            double g = 1 / gamma;
            for (int i = 0; i < 256; i++) table[i] = (byte)(int)(Math.Pow(i / 255.0, g) * 255 + 0.5);

            for (int i = 0; i < width; i++)
                for (int j = 0; j < height; j++)
                {
                    imagematris[i, j, 0] = table[imagematris[i, j, 0]];
                    imagematris[i, j, 1] = table[imagematris[i, j, 1]];
                    imagematris[i, j, 2] = table[imagematris[i, j, 2]];
                }
            Matris.Math.ApplyThreshold(ref imagematris, width, height, 255, 0);

            return Matris.Load.BMPfromeMatris3D(ref imagematris, width, height);
        }
        public static void removeShadows(ref int[, ,] image, int width, int height)
        {
            for (int i = 0; i < width; i++)
            {
                for (int j = 0; j < height; j++)
                {
                    int r = 255 - image[i, j, 0], g = 255 - image[i, j, 1], b = 255 - image[i, j, 2];
                    int m = Math.Min(r, Math.Min(g, b));
                    image[i, j, 0] += m;
                    image[i, j, 1] += m;
                    image[i, j, 2] += m;
                }
            }
        }
        public static Bitmap RemoveShadows(ref Bitmap bmp)
        {
            int w = bmp.Width, h = bmp.Height;
            int[, ,] image = Matris.Load.Matris3DFromeBMP_(ref bmp);
            bmp.Dispose();

            removeShadows(ref image, w, h);
            Matris.Math.ApplyThreshold(ref image, w, h, 255, 0);

            return Matris.Load.BMPfromeMatris3D(ref image, w, h);
        }
        #endregion

        #region clustering
        static public Bitmap Contrast(ref Bitmap bmp, string power)
        {
            int width = bmp.Width, height = bmp.Height;
            Bitmap bmpnew = new Bitmap(width, height);

            int Power = int.Parse(power);
            int slice = 255 / Power;

            for (int i = 0; i < width; i++)
            {
                for (int j = 0; j < height; j++)
                {
                    Color c = bmp.GetPixel(i, j);
                    bmpnew.SetPixel(i, j, Color.FromArgb(
                        (c.A / slice) * slice,
                        (c.R / slice) * slice,
                        (c.G / slice) * slice,
                        (c.B / slice) * slice));
                }
            }

            return bmpnew;
        }
        /// <summary>
        /// رنگ ها را از محدوده
        /// A
        /// به محدوده
        /// B
        /// نگاشت میکند
        /// </summary>
        static public Bitmap Normalize(ref Bitmap bmp, int LowerA, int UpperA, int LowerB, int UpperB)
        {
            int width = bmp.Width, height = bmp.Height;
            int[, ,] image = Matris.Load.Matris3DFromeBMP_(ref bmp);
            Matris.Histogram.StrechHistogram(ref image, width, height, "all", LowerA, UpperA, LowerB, UpperB);
            Matris.Math.ApplyThreshold(ref image, width, height, 255, 0);
            return Matris.Load.BMPfromeMatris3D(ref image, width, height);
        }
        public static Bitmap MSPcontrast16(ref Bitmap image)
        {
            int width = image.Width, height = image.Height;
            Bitmap newimage = new Bitmap(width, height);
            for (int i = 0; i < width; i++)
            {
                for (int j = 0; j < height; j++)
                {
                    Color c = image.GetPixel(i, j);
                    newimage.SetPixel(i, j, Color.FromArgb(
                        c.R > 64 ? c.R > 127 ? c.R > 192 ? 255 : 127 : 64 : 0,
                        c.R > 64 ? c.G > 127 ? c.G > 192 ? 255 : 127 : 64 : 0,
                        c.B > 64 ? c.B > 127 ? c.B > 192 ? 255 : 127 : 64 : 0));
                }
            }
            return newimage;
        }
        #endregion 

        #region noise
        static public Bitmap cleannoise(ref Bitmap bmp, string operation, int winsize)
        {
            int width = bmp.Width, height = bmp.Height;
            int[, ,] imagematris = Matris.Load.Matris3DFromeBMP_(ref bmp), newimagematris = new int[width, height, 3];

            newimagematris = Matris.Edit.ExpandAndCentralize(ref imagematris, width, height, winsize);
            newimagematris = Matris.Filters.cleannoise(ref newimagematris, width + 2 * winsize, height + 2 * winsize, operation, winsize);
            Matris.Math.ApplyThreshold(ref newimagematris, width + 2 * winsize, height + 2 * winsize, 255, 0);
            newimagematris = Matris.Edit.Crop(ref newimagematris, width + 2 * winsize, height + 2 * winsize, winsize, winsize, width + winsize, height + winsize);

            return Matris.Load.BMPfromeMatris3D(ref newimagematris, width, height);
        }
        public static Bitmap AddNoise(ref Bitmap bmp, int winsize, string noiseType)
        {
            int width = bmp.Width, height = bmp.Height;
            Bitmap bmpnew = new Bitmap(width, height);

            int[, ,] image = Matris.Load.Matris3DFromeBMP(bmp);
            for (int i = 0; i < width; i++) for (int j = 0; j < height; j++)
                {
                    switch (noiseType)
                    {
                        case "cross":
                            int[] avgc = Matris.Math.average_cross(ref image, width, height, i, j, winsize);
                            bmpnew.SetPixel(i, j, Color.FromArgb(avgc[0], avgc[1], avgc[2]));
                            break;
                        case "border":
                            int[] avgb = Matris.Math.average_Border(ref image, width, height, i, j, winsize);
                            bmpnew.SetPixel(i, j, Color.FromArgb(avgb[0], avgb[1], avgb[2]));
                            break;
                    }
                }
            return bmpnew;
        }
        #endregion

        #region testing
        //testing functions
        public static string SortPixels(string filename)
        {
            Bitmap image = new Bitmap(filename);
            int[, ,] imageMatris = Matris.Load.Matris3DFromeBMP(image);
            int width=image.Width,height=image.Height;

            int min, max, avg;
            int r, g, b;
            for (int i = 0; i < width; i++)
            {
                for (int j = 0; j < height; j++)
                {
                    r = imageMatris[i, j, 0]; g = imageMatris[i, j, 1]; b = imageMatris[i, j, 2];
                    min = Math.Min(r, Math.Min(g, b));
                    max = Math.Max(r, Math.Max(g, b));
                    avg =
                        (b < r && r < g) ? r : (b > r && r > g) ? r :
                        (r < g && g < b) ? g : (r > g && g > b) ? g :
                        (r < b && b < g) ? b : (r > b && b > g) ? b : 0;
                    /*imageMatris[i, j, 0] = max;
                    imageMatris[i, j, 1] = avg;
                    imageMatris[i, j, 2] = min;*/
                    imageMatris[i, j, 0] = min;
                    imageMatris[i, j, 1] = avg;
                    imageMatris[i, j, 2] = max;
                }
            }

            image.Dispose();
            string newfilename = filename.Replace(".bmp", "._sortPixels.bmp");
            Matris.Save.Matris3DToBMPFile(ref imageMatris, width, height, newfilename);
            return newfilename;
        }
        //oil painting whith one whole window
        public static Bitmap yekdast(ref Bitmap image)
        {
            int width = image.Width, height = image.Height;
            int[, ,] imagematris = Matris.Load.Matris3DFromeBMP(image);
            int[, ,] newimagematris = new int[width, height, 3];

            int[] r = new int[256];
            int[] g = new int[256];
            int[] b = new int[256];
            int[] intensity = new int[256];
            Queue<Point>[] SameColors = new Queue<Point>[256];
            for (int i = 0; i < 256; i++) SameColors[i] = new Queue<Point>();

            for (int x = 0; x < width; x++)
            {
                for (int y = 0; y < height; y++)
                {
                    double intens =
                        0.2125 * Convert.ToDouble(imagematris[x, y, 0]) +
                        0.7154 * Convert.ToDouble(imagematris[x, y, 1]) +
                        0.0721 * Convert.ToDouble(imagematris[x, y, 2]);

                    intensity[Convert.ToInt32(intens)]++;
                    r[Convert.ToInt32(intens)] += imagematris[x, y, 0];
                    g[Convert.ToInt32(intens)] += imagematris[x, y, 1];
                    b[Convert.ToInt32(intens)] += imagematris[x, y, 2];
                    SameColors[Convert.ToInt32(intens)].Enqueue(new Point(x, y));
                }
            }

            //rebuild image
            Point tmp = new Point(0, 0);
            int R = 0, G = 0, B = 0, In = 0;
            for (int i = 0; i < 256; i++)
            {
                In = intensity[i];
                R = In == 0 ? 0 : r[i] / In;
                G = In == 0 ? 0 : g[i] / In;
                B = In == 0 ? 0 : b[i] / In;

                while (SameColors[i].Count != 0)
                {
                    tmp = SameColors[i].Dequeue();
                    newimagematris[tmp.X, tmp.Y, 0] = R;
                    newimagematris[tmp.X, tmp.Y, 1] = G;
                    newimagematris[tmp.X, tmp.Y, 2] = B;
                }
            }

            Matris.Math.ApplyThreshold(ref newimagematris, width, height, 255, 0);
            Bitmap newimage = Matris.Load.BMPfromeMatris3D(ref newimagematris, width, height);

            return newimage;
        }
        #endregion

        public static Bitmap ApplyFilter(ref Bitmap image, int[,] filter, int filtersize, int filterZarib)
        {
            int width = image.Width, height = image.Height;
            int[, ,] imagematris = Matris.Load.Matris3DFromeBMP(image);

            int[, ,] newimagematris = new int[width, height, 3];
            Matris.Math.ApplyFilter(ref imagematris, width, height, ref newimagematris, Matris.Load.Matris3DFromeMatris2D(filter, filtersize, filtersize), filtersize);
            Matris.Math.devide(ref newimagematris, width, height, filterZarib);
            Matris.Math.ApplyThreshold(ref newimagematris, width, height, 255, 0);

            Bitmap newimage = Matris.Load.BMPfromeMatris3D(ref newimagematris, width, height);
            return newimage;
        }//apply user defined filter
        
    }//class filters
}
